#ifndef _TABGENERAL_CPP
#define _TABGENERAL_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Init.H"
#include "../Source/WinService.H"
#include "../Source/Routines.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabGeneralDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND ProductText_hWnd;
    static HWND VersionText_hWnd;
    static HWND BuildDateText_hWnd;
    static HWND OSText_hWnd;
    static HWND MemoryText_hWnd;
    static HWND ProcesorsText_hWnd;

    if(xMessage == WM_INITDIALOG)
    {
        ProductText_hWnd     = GetDlgItem(xHandle, IDC_PRODUCTTEXT);
        VersionText_hWnd     = GetDlgItem(xHandle, IDC_VERSIONTEXT);
        BuildDateText_hWnd   = GetDlgItem(xHandle, IDC_BUILDDATETEXT);
        OSText_hWnd          = GetDlgItem(xHandle, IDC_OSTEXT);
        MemoryText_hWnd      = GetDlgItem(xHandle, IDC_MEMORYTEXT);
        ProcesorsText_hWnd   = GetDlgItem(xHandle, IDC_PROCESORSTEXT);

        //------------------------------------(Fill in general information begin)
        SYSTEM_INFO SI;
        GetSystemInfo(&SI);

        MEMORYSTATUS MS;
        MS.dwLength = sizeof(&MS);
        GlobalMemoryStatus(&MS);

        char TempText[1024];

        Set_Text(ProductText_hWnd, gsTitleCaption);

        sprintf(TempText, "%s at %s", __DATE__, __TIME__);
        Set_Text(BuildDateText_hWnd, TempText);

        Set_Text(VersionText_hWnd, gsFileVersion);

        Get_OsVersionEx(TempText);
        Set_Text(OSText_hWnd, TempText);

        sprintf(TempText, "%d MB", MS.dwTotalPhys/1024/1024);
        Set_Text(MemoryText_hWnd, TempText);

        sprintf(TempText, "%d", SI.dwNumberOfProcessors);
        Set_Text(ProcesorsText_hWnd, TempText);
        // ------------------------------------(Fill in general information end)

        return TRUE;
    }

    if(xMessage == WM_COMMAND)
    {

        return FALSE;
    }

    if(xMessage == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
